require 'rspec'
require 'watir-scroll'

require_relative '../../module/DriverUtility'
require_relative '../rspec_helper'
require_relative '../../pages/varUtility/landing'
require_relative '../../helper/modal'
require_relative '../../common/accessVarUtility'
require_relative '../../common/common'
require_relative '../../pages/varUtility/manage_settings'
require_relative '../../module/DateUtility'
require_relative '../../helper/table'
require_relative '../../pages/varUtility/error_validation'
require_relative '../../pages/varUtility/manage_settings/request_settings'
require_relative '../../pages/varUtility/manage_settings/direct_scheduling'
require_relative '../../pages/varUtility/manage_settings/custom_messages'
require_relative '../../module/database/MongoUtility'
require_relative '../../pages/vaToolSet/home'
require_relative '../../pages/landing_page'

require_relative '../rspec_helper'
require 'vaToolSet/vaToolSet_pageObject'

describe '[Story VARUT-1785: Custom Text: Add Location Display]' do

  include DriverUtility
  include DateUtility
  include MongoUtility

  before(:all) do
    initializeConfigurations(BASE_URL)
    @login = Login.new(@driver)
    @table = Table.new(@driver)
    @home = Home.new(@driver)
    @manage_setting = Manage_Settings.new(@driver)
    @common = Common.new(@driver)
    @direct_scheduling = Direct_Scheduling.new(@driver)
    @request_setting = Request_Settings.new(@driver)
    @custom_messages = Custom_Messages.new(@driver)
    @landing = Landing.new(@driver)
    @landing_page = LandingPage.new(@driver)
    @error = Error_Validation.new(@driver)
    @vts_po  = VaToolSet_PageObject.new(@driver)
    @modal = Modal.new(@driver)
    @vts_po.loginLogout.login(UserAccess7)
    #Access VAR Utility
    @home.varUtilOpen_element.wait_until_present(TIME_OUT_LIMIT)
    @home.varUtilOpen

  end

  after(:all) do
    @driver.close
  end

  context '[AC#VARUT-1815|TC#VARUT1816: Custom Text: Add Location Display]' do |friendly_facility_name_orig, updated_facility_name|

    it 'should open the custom text display' do
      friendly_facility_name_orig = 'BOSTON HCS VAMC'
      @landing_page.facility_location_element.wait_until_present(TIME_OUT_LIMIT)
      @landing_page.facility_location_element.select_value(friendly_facility_name_orig)
      @landing_page.view_settings_element.wait_until_present(TIME_OUT_LIMIT)
      @landing_page.view_settings
      @landing_page.change_location_element.wait_until_present(TIME_OUT_LIMIT)
      expect(@landing_page.options_list_element[2].text).to eq("Custom Text")
      @manage_setting.clickOption('Custom Text')
      @custom_messages.custom_text_heading_element.wait_until_present(TIME_OUT_LIMIT)
      expect(@custom_messages.custom_text_heading_element.text).to eq("#{friendly_facility_name_orig} Custom Text")
      expect(@custom_messages.instructional_custom_text_element.text).to eq("Customize the text below to provide information that is specific to this location and its clinics.")

    end

    it 'Verify the first section displayed is Location Display' do
      @custom_messages.location_display_heading_element.wait_until_present(TIME_OUT_LIMIT)
      expect(@custom_messages.location_display_heading_element.text).to include("Location Display")
    end

    it 'should verify the details of Location Display Section' do
      friendly_facility_name_page = @custom_messages.friendly_name_element.text
      friendly_facility_name_header = @custom_messages.friendly_name_header_element.text.split("\n")
      expect(friendly_facility_name_page).to eq("Site: #{friendly_facility_name_orig} (523)")
      expect(friendly_facility_name_header[0]).to eq("* Facility Location - Friendly Name")
      expect(@custom_messages.restore_default_facility_name_element.present?).to eq(true)
    end

    it 'Verify maximum length allowed for Facility Location - Friendly Name' do
      puts "max length is: ", @custom_messages.facility_name_box_element.max_length
      expect(@custom_messages.facility_name_box_element.max_length).to eq(100)

    end

    it 'should verify that Facility Location - Friendly Name is required' do
      @custom_messages.facility_name_box_element.clear
      @custom_messages.bottomSave
      @error.error_summary_dialogue_element.wait_until_present(TIME_OUT_LIMIT)
      expect(@error.error_summary_dialogue_element.exists?).to eq(true)
      expect(@error.error_summary_dialogue_element.text).to include("Facility Location - Friendly Name field is required")

    end

    it 'should verify that Facility Location - Friendly Name can be updated' do
      updated_facility_name = "My new test"
      @custom_messages.facility_name_box_element.clear
      @custom_messages.facility_name_box_element.set(updated_facility_name)
      @custom_messages.bottomSave
      @modal.modalTitle_element.when_visible(TIME_OUT_LIMIT)
      @modal.ok

    end

    it 'Logout and Log back in as different user for same location to verify the last saved data is displayed' do
      @common.logoutAndLogbackWithADifferentUser("ACCESS50", "VERIFY50!", "BOSTON HCS VAMC")
      @common.waitWhileSpinnerPresent()
      @landing.footerUserInfo_element.when_visible(TIME_OUT_LIMIT)
      Watir::Wait.until {@landing.footerUserInfo == "Logged in as PROVIDER, FIFTY"}
      expect(@landing.footerUserInfo).to eq("Logged in as PROVIDER, FIFTY")
      @home.varUtilOpen
      @landing_page.viewFacilitySettings(friendly_facility_name_orig)
      @landing_page.change_location_element.wait_until_present(TIME_OUT_LIMIT)
      expect(@landing_page.options_list_element[2].text).to eq("Custom Text")
      @manage_setting.clickOption('Custom Text')
      @common.waitWhileSpinnerPresent
      @custom_messages.location_display_heading_element.wait_until_present(TIME_OUT_LIMIT)
      expect(@custom_messages.location_display_heading_element.text).to eq("Location Display")
      expect(@custom_messages.facility_name_box).to eq(updated_facility_name)
    end


    it 'Validate Confirmation Modal When Navigating without Save' do
      @custom_messages.facility_name_box_element.set("My new test facility")
      button_element = @driver.button( :id=>'home-btn')
      @driver.execute_script("$(arguments[0]).click();",button_element)
      @modal.modalTitle_element.when_visible(TIME_OUT_LIMIT)
      #modalTitle = @modal.modalTitle.slice!(12..23)
      modalTitle = @modal.modalTitle.split("\n")
      expect(modalTitle[1]).to eq("Confirmation")
      expect(@modal.content).to eq("You have not saved your changes. If you wish to continue without saving select CONTINUE, otherwise select RETURN to return to the entry screen.")
      @modal.ok_button
    end

    it 'should verify that the default name can be restored' do
      @modal.modalTitle_element.wait_while_present(TIME_OUT_LIMIT)
      sleep 2
      @home.varUtilOpen_element.wait_until_present(TIME_OUT_LIMIT)
      @home.varUtilOpen
      @landing_page.viewFacilitySettings(friendly_facility_name_orig)
      @landing_page.change_location_element.wait_until_present(TIME_OUT_LIMIT)
      expect(@landing_page.options_list_element[2].text).to eq("Custom Text")
      @manage_setting.clickOption('Custom Text')
      @common.waitWhileSpinnerPresent
      Watir::Wait.until{@custom_messages.location_display_heading_element.present?}
      @custom_messages.facility_name_box_element.set("My new test facility")
      @custom_messages.restore_default_facility_name
      @common.waitWhileSpinnerPresent()
      expect(@custom_messages.facility_name_box).to eq(friendly_facility_name_orig)
      @custom_messages.bottomSave

    end

  end

end